PROCEDURE EdfNew

(*
(* EdfNew / EdfSrch /EdfMenu (Basic09)
(*
(* EdFiles utilities
(*
(* Search for NEW files, reads EDFILES format configuration files
(* should be modified to accept FINDSTR key-words for file location
(* searches as well, or modified to create another seperate utility
(*
(* EdfMenu would be a generic file menu interface to the user.
(* it would allow the user to traverse all of the file directories
(* from ONE command from a RiBBS menu.  This interface could be
(* added onto and allow viewing of archives, uploading, downloading
(* searches, etc etc.
(*

(* RiBBS parameters passed for OUTSIDE program
(* DCOM barfed on this one
TYPE address=ad1,ad2,ad3,ad4,local:integer
PARAM RBParm:address
PARAM Name$:STRING[32]
PARAM ULevel:INTEGER
PARAM Timelimit:INTEGER
PARAM OnTime$:STRING[14]
PARAM Cls$:STRING[3]
PARAM CR$:STRING[3]
PARAM Case$:STRING[1]
PARAM Info(12):STRING[32]

DIM ClrBg(9),ClrFg(9):STRING[3]
DIM Temp$:STRING[160]
DIM B0010,B0011,B0012,B0013:BYTE

(* current key read from keyboard or port
DIM Key$:STRING[1]
DIM S0015:STRING[160]

(* Current directory
DIM Dir$,S0017:STRING[80]
DIM S0018:STRING
DIM S0019:STRING[8]

(* DESC.BBS file open flag
DIM DFilOpen:BOOLEAN

(* Areas.BBS open path number array, and the DESC.BBS open path number
DIM AreaPath(10),DescPath:BYTE

(* Areas.BBS level counter
DIM ALevel:INTEGER
DIM Level,I0025,I0026:INTEGER
DIM L0027,L0028:BOOLEAN
DIM B0029:BYTE

(* The current line number displayed per screen and the Maximum lines per screen
DIM CurLine,MaxLine:INTEGER
DIM S0032:STRING[80]
DIM S0033:STRING[20]
DIM Cnt:REAL
DIM I0035:INTEGER
DIM S0036:STRING[20]

(* Current area name
DIM Name$:STRING
DIM S0038:STRING[8]
DIM R0039,R0040:REAL
DIM S0041:STRING

ON ERROR GOTO 50

(* Set up colour configuration
FOR Cnt:=1 TO 7
  ClrBg(Cnt):=CHR$(27)+CHR$(51)+CHR$(Cnt)
  ClrFg(Cnt):=CHR$(27)+CHR$(50)+CHR$(Cnt)
NEXT Cnt

ClrFg(9):=CHR$(27)+CHR$(50)+CHR$(0)
ClrBg(9):=CHR$(27)+CHR$(51)+CHR$(0)

(* set original directory to read 'areas.bbs' from

Dir$="/dd/sys"
DFilOpen:=FALSE
B0013:=0
B0012:=0
IF RBParm.i0000=0 THEN
  MaxLine:=20
ELSE
  MaxLine:=RBParm.i0000
ENDIF

(* get system information (ustats.sys)
GOSUB 110
Temp$:=Cls$+ClrBg(9)+ClrFg(1)+"Scanning "+S0032+ClrFg(1)+" for New Files."+ClrFg(6)+CR$
GOSUB 20
Temp$:=CR$+ClrFg(2)+"Enter the date to start from"+ClrFg(7)+" <YY/MM/DD>:"+CR$+ClrFg(1)+"     <CR>="+ClrFg(3)+LEFT$(Info(11),8)+ClrFg(7)+"          :"+ClrFg(3)+ClrBg(4)
Temp$:=Temp$+"           "

GOSUB 20

(* backspace to beginning of field
FOR R0039:=1 TO 10
  Temp$:=CHR$(8)
  GOSUB 20
NEXT R0039

S0038:=""
FOR I0025:=1 TO 6
  (* read a number from the keyboard
  GOSUB 100
  EXITIF L0028=TRUE THEN
    I0026:=LEN(S0038)
    S0038:=""
  ENDEXIT
  S0038:=S0038+Key$
  IF I0025=2 OR I0025=5 THEN
    Temp$:="/"
    S0038:=S0038+Temp$
    GOSUB 20
  ENDIF
  IF S0038="" THEN
    S0038:=LEFT$(Info(11),8)
    Temp$:=""
    (* backspace over text and re-print it
    FOR I0025:=1 TO I0026
      Temp$:=Temp$+CHR$(8)
    NEXT I0025
  ENDIF
CurLine:=0
Temp$:=CR$+ClrFg(3)+"Search All directories or Prompted <"+ClrFg(7)+ClrBg(1)+"A"+ClrBg(9)+ClrFg(3)+"/p>?"+ClrBg(9)+ClrFg(6)
GOSUB 20
GOSUB 30
IF Key$="p" OR Key$="P" THEN
  L0027:=TRUE
ELSE
  L0027:=FALSE
ENDIF
Temp$:=CR$+Cls$+ClrFg(1)+"Press <"+ClrFg(3)+"S"+ClrFg(1)+"> to stop or <"+ClrFg(3)+"P"+ClrFg(1)+"> to pause listing at any time."+ClrFg(6)
+CR$
GOSUB 20
(* read AREAS.BBS and go through each area and/or sub-area
GOSUB 1000
Temp$:=ClrFg(5)+"Press any Key"
GOSUB 20
GOSUB 30
END

(* **************************************************************************

(* display a line of text to screen and port
20 RUN lineout(RBParm,Temp$,Case$)
   GOSUB 80
   RETURN

(* *************************************************************************

(* wait for a key from the keyboard or port
30 GOSUB 80
   RUN onekey(RBParm,Key$,B0010)
   RETURN

40 RUN CHARIN(RBParm,Key$,B0010)
   IF Key$="S" OR Key$="s" THEN
     Temp$:=ClrFg(1)+CR$+"Aborting Search"+CR$
     GOSUB 20
     GOTO 60
   ENDIF
   IF Key$<>CHR$(13) THEN
     GOTO 40
   ENDIF
   RETURN

   GOSUB 80
   RUN linein(RBParm,Case$,Temp$,B0012,B0013)
   GOSUB 80
   RETURN

(* ****************************************************************************

(* error handling routine
50 PRINT "System Error ";
   PRINT ERR
   PRINT "Press <ENTER> to return to BBS";
   INPUT Temp$
   END

(* *************************************************************************

(* read a line from DESC.BBS
70 IF NOT(EOF(#DescPath)) THEN
     READ #DescPath,S0015
   ELSE
     S0015:="END"
   ENDIF
   RETURN

(* ************************************************************************

(* check for loss of carrier
80 RUN cdcheck(RBParm,B0011)
   IF B0011<>0 THEN
     PRINT "Carrier Lost in NEWFILE"
     GOTO 60
   ENDIF
   RETURN

90 RUN CHARIN(RBParm,Key$,B0010)
   IF Key$="s" OR Key$="S" THEN
     Temp$:=ClrFg(1)+"Aborting Search"+CR$
     GOSUB 20
     GOTO 60
   ENDIF
   IF Key$="P" OR Key$="p" THEN
     Temp$:=ClrFg(6)+"Paused  -  Press <Enter> to continue"
     GOSUB 20
     GOSUB 40
     GOSUB 80
     Temp$:=""
     FOR I0025:=1 TO 36
       Temp$:=Temp$+CHR$(8)
     NEXT I0025
     GOSUB 20
     Temp$:="                                    "
     GOSUB 20
     Temp$:=""
     FOR I0025:=1 TO 36
       Temp$:=Temp$+CHR$(8)
     NEXT I0025
     GOSUB 20
   ENDIF
   RETURN

(* ****************************************************************************

(* read in a number from the keyboard (or the whole date?)
100 REPEAT
      L0028:=FALSE
      GOSUB 80
      RUN CHARIN(RBParm,Key$,B0010)
      IF Key$=CHR$(13) THEN
        L0028:=TRUE
      ELSE
        IF Key$<"0" OR Key$>"9" THEN
          Key$:=""
        ENDIF
      ENDIF
    UNTIL Key$<>""
    IF L0028=FALSE THEN
      Temp$:=Key$
      GOSUB 20
    ELSE
      Key$:=""
    ENDIF
    RETURN

(* ************************************************************************

(* read in system name - change this to read RiBBS.CFG
110 ON ERROR GOTO 120
    OPEN #B0029,"ustats.sys":READ
    READ #B0029,S0032
    CLOSE #B0029
    RETURN

120 S0041:="All Directories"
    ON ERROR GOTO 50
    RETURN

(* **************************************************************************

1000 REM
(* On Entry : Dir$ must have the directory that AREAS.BBS or DESC.BBS is
(* going to be read from
(*
(* reads in AREAS.BBS for area names/paths/and access levels
(* if another AREAS.BBS is found in a sub-dir, it will be read in and scanned
(*
     ALevel:=ALevel+1
     (* set up error trap for NO AREAS.BBS
     ON ERROR GOTO 1100
     PRINT "Opening "+Dir$+"/areas.bbs"
     OPEN #AreaPath(ALevel),Dir$+"/areas.bbs":READ
     (* reset normal error trap
     ON ERROR GOTO 50
     WHILE NOT(EOF(#AreaPath(ALevel))) DO
       READ #AreaPath(ALevel),Dir$
       (* add in LEVEL and FLAGS to path lines in AREAS.BBS
       Level:=1
       (* attempt the read of AREAS.BBS in each directory
       GOSUB 1000
       IF Level<=ULevel THEN
         IF NOT(L0027) THEN
           Temp$:=ClrFg(7)+"Checking "+ClrFg(4)+Name$+CR$
           CurLine:=CurLine+1
           GOSUB 20
           GOSUB 90
         ELSE
           Temp$:=ClrFg(7)+"Check "+ClrFg(9)+ClrBg(6)+"<"+Name$+">"+ClrBg(9)+ClrFg(7)+"?"+ClrBg(1)+" "+CHR$(8)+ClrFg(7)+ClrBg(9
           GOSUB 20
           GOSUB 30
           (* check for stop key
           IF Key$="s" OR Key$="S" THEN
             GOSUB 20
             GOTO 60
           ENDIF
           IF Key$<>"Y" AND Key$<>"y" THEN 10
         ENDIF

         (* open DESC.BBS for date checks (and SUB-STRING checks)
         OPEN #DescPath,Dir$+"/Desc.bbs":READ
         DFilOpen:=TRUE
         WHILE NOT(EOF(#DescPath)) DO
           GOSUB 70
           S0017:=S0015
           EXITIF S0015="END" THEN
           ENDEXIT
           GOSUB 70
           S0018:=S0015
           EXITIF S0015="END" THEN
           ENDEXIT
           GOSUB 70
           S0019:=S0015
           EXITIF S0015="END" THEN
           ENDEXIT
           GOSUB 70
           S0033:=S0015
           EXITIF S0015="END" THEN
           ENDEXIT
           GOSUB 90
           IF S0019>=S0038 THEN
             I0035:=22-LEN(S0017+S0033)
             S0036:=""
             IF I0035>0 THEN
               REPEAT
                 S0036:=S0036+" "
               UNTIL LEN(S0036)=I0035
             ENDIF
             Temp$:=ClrBg(4)+ClrFg(3)+S0017+S0036+ClrFg(1)+S0033+ClrFg(2)+"  "+LEFT$(S0019,8)+"   "+ClrFg(7)+"Uploaded By: "+ClrFg(6)+S0018+ClrFg(7)+ClrBg(9)+CR$
             GOSUB 20
             GOSUB 70
             EXITIF S0015="END" THEN
             ENDEXIT
             GOSUB 70
             EXITIF S0015="END" THEN
             ENDEXIT
             IF S0015<>"-" THEN
               Temp$:=ClrFg(2)+"Short Description:"+CR$
               CurLine:=CurLine+3
               GOSUB 20
               Temp$:=ClrFg(6)+S0015+ClrFg(7)+CR$
               GOSUB 20
               Temp$:="-------------------------------------------------------------"+CR$
               GOSUB 20
               GOSUB 90
             ENDIF
             CurLine:=CurLine+1
           ENDIF
           IF CurLine>=MaxLine THEN
             CurLine:=0
             Temp$:="Press <Enter> to continue"
             GOSUB 20
             GOSUB 40
             FOR R0039:=1 TO 25
               Temp$:=CHR$(8)
               GOSUB 20
             NEXT R0039
           ENDIF
           IF S0015<>"-" THEN
             REPEAT
               GOSUB 70
               EXITIF S0015="END" THEN
               ENDEXIT
             UNTIL S0015="-"
           ENDIF
         ENDWHILE
         CLOSE #DescPath
         DFilOpen:=FALSE
       ENDIF
     ENDWHILE

     (* if AREAS.BBS could not be read, exec. comes here
1100 CLOSE #AreaPath(ALevel)
     RETURN
     END
