PROCEDURE cvthdr210
REM ************************************************************
REM *             Message Base Convert                         *
REM *             for RiBBS v2.02     by Ron Bihler            *
REM *             copyright 1991                               *
REM *                                                          *
REM *  This program may be modified, as long as the above      *
REM *  lines remain intact and Credit is given to the          *
REM *  original Author   (Myself Ron Bihler)                   *
REM *                                                          *
REM *  04/11/91 - Updated by Charles West to :                 *
REM *            > Read RiBBS.CFG for MB pathname              *
REM *            > Use Syscall to size NewHdr as quickly as    *
REM *              possible, using as few segments as possible *
REM *            > Automatically calculates ideal HDR size     *
REM *  06/15/92 - Update by Charles West to :                  *
REM *            > Convert Mbase v2.02 headers to v2.10 format *
REM ************************************************************
DIM filename:STRING[40]
DIM mbpth:STRING[20]
DIM nowsize,maxsize,idealsize:REAL
TYPE registers=cc,a,b,dp:BYTE; lx,ly,lu:INTEGER
DIM reg:registers
DIM zone:INTEGER
DIM callcode:BYTE
5 
PRINT CHR$(12); 
PRINT "                    v2.02 to v2.10 Message Base Convert Util."
PRINT "                         by Ron Bihler and Charles West"
PRINT 
PRINT "Reading RiBBS.cfg..."; 
(* INPUT "Message Base Dir - Pathname :",filename
(* INPUT "Allocate for how many messages ?",msg
6 PRINT 
bd=0
7 ON ERROR GOTO 100
ON ERROR 
DIM path,lownum,hinum,lastr,path1:INTEGER
DIM nfmsg(40),nhmsg(40):INTEGER
DIM ilownum,ihinum,ilastrec:INTEGER
DIM er,er1:BOOLEAN
er1=FALSE
er=FALSE
OPEN #path,"/dd/ribbs.cfg":READ
SEEK #path,$14
GET #path,mbpth
SEEK #path,302
GET #path,zone
CLOSE #path
TYPE format2=board2:BYTE; ln2,number2,mzone2,mnet2,mnode2,mpoint2 ,ref12,ref22,pmsg2,nmsg2:INTEGER; poss2:REAL; f2(8):BOOLEAN; to2$ ,from2$,sub2$:STRING[32]; dt2$:STRING[20]
TYPE format=board,ln:BYTE; number,mnet,mnode,ref1,ref2,pmsg,nmsg :INTEGER; poss:REAL; f(8):BOOLEAN; to$,from$,sub$:STRING[32]; dt$ :STRING[20]
DIM header:format
DIM header2:format2
OPEN #path,mbpth+"/hdr":READ
CREATE #path1,mbpth+"/Newhdr":WRITE
SEEK #path,2
GET #path,lownum
GET #path,hinum
GET #path,lastr
GET #path,nowsize
GET #path,maxsize
SEEK #path,20
GET #path,nfmsg
SEEK #path,120
GET #path,nhmsg
(* Basically, the idea here is to project how many messages the MBase can
(* hold (based on the current average and the Max-size of the TEXT file)
(* and then round up to the nearest hundred messages.  That total is used
(* to extrapolate the ideal maximum size of HDR.
idealsize=400+SIZE(header2)*(INT((lastr+(maxsize-nowsize)/(nowsize /lastr)+99)/100)*100)
PRINT CHR$(9); "Ideal HDR file size = "; idealsize
reg.a=path1
reg.b=$02
callcode=$8E
reg.lx=INT(idealsize/65536.)
reg.lu=INT(idealsize-reg.lx*65536.)
RUN syscall(callcode,reg)
SEEK #path1,2
PUT #path1,lownum
PUT #path1,hinum
PUT #path1,lastr
PUT #path1,nowsize
PUT #path1,maxsize
PRINT 
PRINT lastr; " Messages   Numbers "; lownum; " to "; hinum
PRINT CHR$(2)+CHR$($20+10)+CHR$($20+10); "Record Number "; 
SEEK #path1,20
PUT #path1,nfmsg
SEEK #path1,120
PUT #path1,nhmsg
FOR i=1 TO lastr
SEEK #path,(i-1)*SIZE(header)+400
GET #path,header
PRINT CHR$(2)+CHR$($20+30)+CHR$($20+10); i; 
SEEK #path1,(i-1)*SIZE(header2)+400
header2.board2=header.board
header2.ln2=header.ln
header2.number2=header.number
header2.mzone2=zone
header2.mnet2=header.mnet
header2.mnode2=header.mnode
header2.mpoint2=0
header2.ref12=header.ref1
header2.ref22=header.ref2
header2.pmsg2=header.pmsg
header2.nmsg2=header.nmsg
header2.poss2=header.poss
header2.f2=header.f
header2.to2$=header.to$
header2.from2$=header.from$
header2.sub2$=header.sub$
header2.dt2$=header.dt$
PUT #path1,header2
NEXT i
CLOSE #path,#path1
PRINT  \ PRINT 
PRINT "Conversion complete.  Now rename 'HDR' to 'oldHDR' and rename 'NewHDR' to "
PRINT "'HDR' and test your base with RiBBS v2.10 installed.  When you have "
PRINT "determined it works, you can delete 'oldHDR'."
END 
100 PRINT "Error in convert"
ON ERROR 
CLOSE #path,#path1
