PROCEDURE watchcd
(* 
(* 
(* Copyright (C) 1989, 1990, 1991 Guy R. Loucks and Bruce Isted
(* 
(* This program may be freely distributed as long as the copywright notice
(* remains intact, and the source, and the binary, and the documentation files
(* are distributed together.
(* 
(* This program may not be used in whole or in part for profit, individually or
(* as part of a package without the prior written permission of the copyright
(* holders.
(* 
(* This program is distributed without warranty, either expressed or implied.
(* The copyright holders shall have no liability or responsibility to users or
(* any other person(s) or entity with respect to any liability, loss or
(* damage caused or alleged to be caused directly or indirectly by the use of
(* this software, including, but not limited to,
(* Any interuption of service, loss of business or anticipatory
(* profits or consequential damages resulting from the use or operation of this
(* software.
(* In no event shall the copyright holders be liable for loss of profits, or
(* any indirect, special, or consequential damages arising in any manner out
(* of the use of this software.*)
TYPE address=ad1:INTEGER; ad21,ad22:BYTE; ad3,ad4,local:INTEGER
PARAM la:address
PARAM na$:STRING[32]
PARAM tlimit:INTEGER
PARAM ontime:STRING[14]
PARAM cr:STRING[3] \(* {CR} String *)
PARAM hlpfile:STRING[32] \(* Process name passed from MENU *)
PARAM logpath:STRING[20]
DIM packet(32):BYTE \(* GetStatus Packet *)
DIM packetset(32):BYTE \(* Save of original Packet *)
DIM filename:STRING[80] \(* Procedure which we might run *)
DIM elapsedtime:REAL
DIM wnum,wrap:BYTE
wnum:=0 \wrap:=0
DIM buffer(512):BYTE
filename:=hlpfile
TYPE r=cc,a,b,dp:BYTE; lx,ly,lu:INTEGER
DIM reg:r
DIM callcode:BYTE
DIM lpath:BYTE
DIM timeon:STRING[25]
DIM a$:STRING[32]
DIM b$,c$:STRING[80]
DIM stin,stout,sterr:BYTE
DIM nwin,nwout,nwerr:BYTE
DIM sysnum(3):BYTE
DIM cd,child,procstate:BYTE
DIM i,j,errnum,ourpid,pid:INTEGER
timeon=DATE$
IF filename="" OR filename=" " THEN 
b$:=cr+"Enter process to run:  "
GOSUB 200 \(* Write Out line *)
GOSUB 210 \(* Read In line *)
IF b$="" THEN 
END 
ENDIF 
filename:=b$
ENDIF 
b$:=cr+"WatchCD Version 2.015"+cr
GOSUB 200
b$:=cr+"Copyright (C) 1989, 1990, 1991, Guy R. Loucks and Bruce Isted"
+cr
GOSUB 200
b$:="Written for use with RiBBS, all rights reserved"+cr
GOSUB 200


b$:=cr+"Loading '"+filename+"'."
GOSUB 200
PRINT CHR$(12)
PRINT "Outside program '"+filename+"' running."
callcode:=$8D \(* I$Getstt *)
reg.a:=la.ad1 \(* Path to Modem *)
reg.b:=0 \(* SS.Opt *)
reg.lx:=ADDR(packet) \(* Address to store packet *)
RUN syscall(callcode,reg)
IF la.local=0 THEN 
packetset:=packet
packet(3):=1 \(* BSB *)
packet(4):=1 \(* CR/LF *)
packet(5):=1 \(* Echo ON *)
packet(6):=1 \(* Auto LF *)
packet(10):=$08 \(* BS Char *)
packet(11):=$18 \(* Line Delete *)
packet(12):=$0D \(* EOR *)
packet(13):=$1B \(* EOF *)
packet(17):=3 \(* Break *)
packet(18):=5 \(* Quit *)
packet(19):=$08 \(* BS Echo Char *)
callcode:=$8E \(* I$SetStt *)
reg.b:=0
RUN syscall(callcode,reg) \(* Save the changes *)
REM Dup Standard Paths so that they can be reopened later
reg.a:=0
callcode:=$82 \(* I$Dup *)
RUN syscall(callcode,reg)
stin:=reg.a
reg.a:=1
RUN syscall(callcode,reg)
stout:=reg.a
reg.a:=2
RUN syscall(callcode,reg)
sterr:=reg.a
REM Close Standard Paths
reg.a:=0
callcode:=$8F \(* I$Close *)
RUN syscall(callcode,reg)
reg.a:=1
RUN syscall(callcode,reg)
reg.a:=2
RUN syscall(callcode,reg)
reg.a:=la.ad1
callcode:=$82 \(* I$Dup *)
RUN syscall(callcode,reg)
nwin:=reg.a
reg.a:=la.ad1
RUN syscall(callcode,reg)
nwout:=reg.a
reg.a:=la.ad1
RUN syscall(callcode,reg)
nwerr:=reg.a
ELSE 
b$:="Tmode echo"
SHELL b$
ENDIF 
b$:=TRIM$(b$)
b$:=filename+CHR$($0D)
i:=SUBSTR(" ",b$)
j:=LEN(b$)
IF i<>0 THEN 
a$:=LEFT$(b$,i)
a$:=a$+CHR$($0D)
c$:=RIGHT$(b$,j-i)
c$:=c$+CHR$($0D)
ELSE 
a$:=b$
c$:=CHR$($0D)
ENDIF 
callcode:=$21 \(* F$NMLink *)
reg.a:=$00
reg.lx:=ADDR(a$)
RUN syscall(callcode,reg)
IF LAND(reg.cc,$01)<>$00 THEN 
callcode:=$22 \(* F$NMLoad *)
reg.a:=$00
reg.lx:=ADDR(a$)
RUN syscall(callcode,reg)
ENDIF 
filename:=filename+CHR$($0D)
reg.b:=(reg.ly+255)/256
callcode:=$03 \(* F$Fork *)
reg.lx:=ADDR(a$)
reg.ly:=j-i
reg.lu:=ADDR(c$)
ON ERROR GOTO 150
RUN syscall(callcode,reg)
IF LAND(reg.cc,$01)=$00 THEN 
child:=reg.a
ELSE 
errnum:=reg.b
ERROR errnum
ENDIF 
ON ERROR GOTO 100
IF la.local=0 THEN 
10 
REPEAT 
callcode:=$0A \(* F$Sleep *)
reg.lx:=180 \(* 3 second *)
RUN syscall(callcode,reg)
callcode:=$18 \(* F$GPrDsc *)
reg.a:=child
reg.lx:=ADDR(buffer)
RUN syscall(callcode,reg)
IF LAND(reg.cc,$01)<>$00 THEN 
errnum:=reg.b
ERROR errnum \(* Tried to find our child, but can't, must have died.. *)
ENDIF 
procstate:=buffer(13)
RUN elapsed(la,ontime,elapsedtime) \(* How much time has passed ??? *)
callcode:=$8D \(* I$GetStt *)
reg.a:=$00
reg.b:=la.ad22 \(* RiBBS config get CD status call *)
RUN syscall(callcode,reg)
IF LAND(reg.cc,$01)<>$00 THEN 
errnum:=reg.b
ERROR errnum
ELSE 
cd:=LAND(reg.b,la.ad21)
ENDIF 
IF elapsedtime>tlimit OR cd<>0 THEN 
(* Check for Valid CD, and time available *)
callcode:=$0C \(* F$ID *) \ (* Get OUR Id *)
RUN syscall(callcode,reg)
ourpid:=reg.a
callcode:=$18 \(* F$GPrDsc *)
reg.lx:=ADDR(buffer)
RUN syscall(callcode,reg)
(* get system's numbers for our standard I/O paths *)
(* note:  system's numbers are not the same as path numbers *)
sysnum(1):=buffer(49) \(* standard input *)
sysnum(2):=buffer(50) \(* standard output *)
sysnum(3):=buffer(51) \(* standard error output *)
FOR pid=2 TO 255
IF pid<>ourpid THEN 
(* Check to make sure it is not us, we do not wan't to commit suicide *)
callcode:=$18 \(* F$GPrDsc *)
reg.a:=pid
reg.lx:=ADDR(buffer)
RUN syscall(callcode,reg)
IF LAND(reg.cc,$01)=$00 THEN 
IF pid=child OR sysnum(1)=buffer(49) OR sysnum(2)=buffer(50) OR sysnum
(3)=buffer(51) THEN 
(* Ok, it is Our child, or grandchild process, lets KILL it... *)
reg.a:=pid
reg.b:=$00 \(* S$Kill *)
callcode:=$08 \(* F$Send *)
RUN syscall(callcode,reg) \(* KILL it *)
ENDIF 
ENDIF 
ENDIF 
NEXT pid
ENDIF 
IF elapsedtime+5>tlimit AND elapsedtime<>lastmin THEN 
PRINT 
PRINT "You have only "; elapsedtime-tlimit; " minutes left."
lastmin:=elapsedtime
ENDIF 
UNTIL LAND(procstate,$03)<>$00 \(* Until Process finishes *)
100 
ON ERROR GOTO 150
errnum:=ERR
errnum:=0
callcode:=$04 \(* F$Wait *)
reg.a:=child
RUN syscall(callcode,reg)
IF LAND(reg.cc,$01)<>$00 THEN 
errnum:=reg.b
ENDIF 
150 
ON ERROR GOTO 190
IF errnum<>0 THEN 
PRINT "Error "; errnum; "."
ENDIF 
callcode:=$8F \(* I$Close *) \ (* Let's clean up the paths *)
reg.a:=0
RUN syscall(callcode,reg)
reg.a:=1
RUN syscall(callcode,reg)
reg.a:=2
RUN syscall(callcode,reg)
callcode:=$82 \(* I$Dup *)
reg.a:=stin
RUN syscall(callcode,reg)
reg.a:=stout
RUN syscall(callcode,reg)
reg.a:=sterr
RUN syscall(callcode,reg)
callcode:=$8F \(* I$Close *)
reg.a:=stin
RUN syscall(callcode,reg)
reg.a:=stout
RUN syscall(callcode,reg)
reg.a:=sterr
RUN syscall(callcode,reg)
ELSE 
callcode:=$04 \(* F$Wait *)
RUN syscall(callcode,reg)
b$:="Tmode -echo"
SHELL b$
ENDIF 
190 
ON ERROR GOTO 195
reg.a:=la.ad1 \(* Time to restore the SCF settings *)
reg.b:=0
reg.lx:=ADDR(packetset)
callcode:=$8E
RUN syscall(callcode,reg)

195 
(* addition by Wes Gale Jan, '92 *)
(* Unlink file by name to make sure it is removed from memory *)
(* search for first space and terminate string there *)
reg.a:=0
reg.lx:=ADDR(filename)
callcode=$1D
RUN syscall(callcode,reg)
b$=". WatchCD v2.015 ("+timeon+" - "+DATE$+") "+filename
PRINT b$+cr
proc$="logout"
RUN proc$(logpath,b$)
KILL proc$
(* end addition - also changed version number up by .01 *)
END 

200  \(* Write out a line *)
proc$:="Lineout"
RUN proc$(la,b$,"l")
RETURN 
210  \(* Get a line of input *)
RUN linein(la,"l",b$,wnum,wrap)
RETURN 
